************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE :MAY 2002
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-12     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-12
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*    .OPTIONS GSHUNT=1E-10   
******IF THERE IS TIMESTEP CCONVERGENCE PROBLEM TRY TO CHANGE GMIN AND GMINDC OR**GSHUNT***


***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      AHC16244INC.INC       (netlist)
*      EPIC1SL49NINC.INC        (Nominal process models)
*      EPIC1SL49SINC.INC        (Strong process models) 	
*      EPIC1SL49WINC.INC        (Weak    process models)
*      PKGS.LIB                 (PKG LIBRARY FILE)
*	SSOP48.PKG
*	TSSOP48.PKG
*	TVSOP48.PKG

*      (Choose only one package model and one process model)
*      .
*      .
*      .
***********************************************************************
	.OPTIONS search='./'

**  ENCRYPTED  DEVICE NETLIST *****
X_DEVICE_SELECTOR  0 AHC16244INC

*** ENCRYPTED PROCESS MODEL

**PLEASE USE ANY ONE OF THE PROCESS MODEL**
** NOMINAL LEVEL 49 PROCESS MODEL**

X_PROCESS_SELECTOR 0  EPIC1SL49NINC      

** STRONG PROCESS MODEL

*X_PROCESS_SELECTOR 0 EPIC1SL49SINC 

** WEAK PROCESS MODEL 

*X_PROCESS_SELECTOR 0  EPIC1SL49WINC

*PLEASE USE ANY ONE PACKAGE
*	.LIB 'PKGS.LIB' SSOP48
	.LIB 'PKGS.LIB' TSSOP48
*	.LIB 'PKGS.LIB' TVSOP48
***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xahc16244 

+x_1noe       
+x_1a1
+x_1y1
+cvcc
+cgnd


+ahc16244

***********************************************************************
******Supply Voltages
***********************************************************************

Vcgnd		cgnd	0  dc  0v
Vcvcc		cvcc  0  dc 3.3v

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT ahc16244  

+p_1noe       	$PIN_01
+p_1a1		$PIN_47
+p_1y1		$PIN_02
+p_cvcc		$PIN_07
+p_cgnd		$PIN_04

X_PIN01      	p_1noe      	noe  	TSSOP48_01
X_PIN02      	p_1y1      	y1  	TSSOP48_02
X_PIN47      	p_1a1      	a1  	TSSOP48_47
X_PIN07		p_cvcc		cvcc	TSSOP48_07
X_PIN04		p_cgnd		cgnd	TSSOP48_04
 
X_ahc16244_bit  noe  a1 y1   cvcc cgnd  ahc16244__bit


.ENDs ahc16244

*****THE FOLLOWING IS A TEST SIMULATION***********
 

***********************************************************************
***********************************************************************
.temp 40
.param biashv=3.3v
.param biaslv=0.0

.param capload=15p

***********************************************************************
.TRAN         0.05NS 50NS

*
**** TRANSIENT ANALYSES <-------

** Propagation test (LH/HL)



Vnoe	   x_1noe    	0  	dc   0v       

Va1	   x_1a1	  	0	PULSE (biaslv  biashv  5NS  1NS  1NS  5.25NS  12.5NS)
	

C_LOAD     x_1y1     0     	capload

.END


