*  HD3SS3415
*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.  
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers make no warranties, either expressed
** or implied, with respect to this model, including the warranties of 
** merchantability or fitness for a particular purpose.  The model is
** provided solely on an "as is" basis.  The entire risk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:               HD3SS3415
* Date:               2/08/11
* Model Type:         Transient
* Simulator:          HSPICE
* Simulator Version:  HSPICE_A-2008.03-SP1 on Windows
* Datasheet:          Rev 0.86 Nov 2010
*
* Model Version:      1.0
*
*****************************************************************************
*
* Updates:
*
* Version 1.0 :       Original Netlist of the Device without Package Information
*
*****************************************************************************
*.subckt HDS3SS3415_ELAB a0n a0p a1n a1p b0n b0p b1n b1p c0n c0p c1n c1p dc_couple gnd sel vcc
*
*.ends HDS3SS3415_ELAB
*****************************************************************************

.PARAM vcc=3.3
.PARAM cpara=150e-15


************************************************************
* By Commenting or Uncommenting the next 2 lines, the user chooses Analysis Type 
*.PROBE AC
.PROBE TRAN
************************************************************
+    V(a0n_i)
+    V(a0p_i)
+    V(a1n_i)
+    V(a1p_i)
+    I(c40)
+    I(c41)
+    V(c1)
+    V(c0)
+    V(nd)
+    V(nc)
+    V(nb)
+    V(na)
+    V(n7)
+    V(n5)
+    V(n3)
+    V(n1)
+    V(n8)
+    V(n6)
+    V(n4)
+    V(n2)

************************************************************
* By Commenting or Uncommenting the next two lines, the user chooses Analysis Type 
*.AC DEC 20 10 100e9
.TRAN 20e-12 200e-9 START=0.0
************************************************************
.TEMP 25


.OPTION ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTION METHOD=GEAR

.INCLUDE "model_nominal_enc_windows.sp"
.INCLUDE "HD3SS3415_subckt_enc_windows.sp"

v1 na 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 0 50e-12 50e-12 9.95e-9 20e-9
v2 nb 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 10e-9 50e-12 50e-12 9.95e-9 20e-9
v4 nd 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 10e-9 50e-12 50e-12 9.95e-9 20e-9
v3 nc 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 0 50e-12 50e-12 9.95e-9 20e-9
va1n n7 nd DC=0 AC 1 180
va1p n5 nc DC=0 AC 1 0
va0n n3 nb DC=0 AC 1 180
va0p n1 na DC=0 AC 1 0

xi0 a0n_i a0p_i a1n_i a1p_i b0n_i b0p_i b1n_i b1p_i c0n_i c0p_i c1n_i c1p_i net013 gnd sel_i vcc HDS3SS3415_ELAB

e7 c0 gnd VCVS c0p c0n 1
e6 c1 gnd VCVS c1p c1n 1
e1 b1 gnd VCVS b1p b1n 1
e0 b0 gnd VCVS b0p b0n 1

r104 gnd a1n_i 10e6
r103 gnd a1p_i 10e6
r102 gnd a0n_i 10e6
r101 gnd a0p_i 10e6
r91 gnd c1p 50
r89 gnd c0n 50
r90 gnd c0p 50
r79 gnd b0p 50
r80 gnd b0n 50
r78 gnd b1p 50
r70 gnd b1n 50
ri4 n7 n8 50
ri3 n5 n6 50
ri2 n3 n4 50
r92 gnd c1n 50
ri1 n1 n2 50
v0 sel_i 0 DC=vcc
v8 vcc 0 DC=vcc
v5 gnd 0 DC=0
c58 c1n c1n_i 75e-9
c55 c0n c0n_i 75e-9
c57 c1p c1p_i 75e-9
c56 c0p c0p_i 75e-9
c36 b1n b1n_i 75e-9
c44 b1p b1p_i 75e-9
c45 b0p b0p_i 75e-9
c46 b0n b0n_i 75e-9
c38 a1p_i n6 75e-9
c40 a0n_i n4 75e-9
c41 a0p_i n2 75e-9
c39 a1n_i n8 75e-9

cesd1  a0p_i 0 300e-15
cesd2  a0n_i 0 300e-15
cesd3  a1p_i 0 300e-15
cesd4  a1n_i 0 300e-15
cesd5  b0p_i 0 300e-15
cesd6  b0n_i 0 300e-15
cesd7  b1p_i 0 300e-15
cesd8  b1n_i 0 300e-15
cesd9  c0p_i 0 300e-15
cesd10 c0n_i 0 300e-15
cesd11 c1p_i 0 300e-15
cesd12 c1n_i 0 300e-15
cesd13 sel_i 0 300e-15

.END
