*  HD3SS3411
*****************************************************************************
* (C) Copyright 2012 Texas Instruments Incorporated. All rights reserved.  
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers make no warranties, either expressed
** or implied, with respect to this model, including the warranties of 
** merchantability or fitness for a particular purpose.  The model is
** provided solely on an "as is" basis.  The entire risk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: WEBENCH (R)Design Center, Texas Instruments Inc.
* Part:               HD3SS3411
* Date:               9/27/13
* Model Type:         AIO  
* Simulator:          HSPICE
* Simulator Version:  HSPICE_A-2008.03-SP1 on Windows
*                     HSPICE D-2010.03-SP2 32 BIT on Linux
* Datasheet:          Rev 0.86 Nov 2010
*
* Model Version:      1.0
*
*****************************************************************************
*
* Updates:
*
* Version 1.0 :       Original Netlist of the Device without Package Information
*
*****************************************************************************
*.subckt HDS3SS3412_A a0n a0p b0n b0p c0n c0p dc_couple gnd sel vcc
*
*.ends HDS3SS3412_A
*****************************************************************************

.PARAM vcc=3.3
.PARAM cpara=150e-15


.PROBE TRAN
+    V(a0n_i)
+    V(a0p_i)
+    v(b0n_i)
+    v(b0p_i)
+    v(c0n_i)
+    v(c0p_i)

*.AC DEC 20 10 100e9
.TRAN 20e-12 200e-9 START=0.0

.TEMP 25


.OPTION ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTION METHOD=GEAR CONVERGE=1


.INCLUDE "process_nominal_enc.sp"
.INCLUDE "HD3SS3411_FET_subckt_enc.sp"

v1 na 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 0     50e-12 50e-12 9.95e-9 20e-9
v2 nb 0 DC=0 AC 0 0 PULSE 500e-3 -0.5 10e-9 50e-12 50e-12 9.95e-9 20e-9
va0n n3 nb DC=0 AC 1 180
va0p n1 na DC=0 AC 1 0

xi0 a0n_i a0p_i b0n_i b0p_i c0n_i c0p_i net013 gnd sel_i vcc HDS3SS3412_A

e7   c0 gnd VCVS c0p c0n 1
e0   b0 gnd VCVS b0p b0n 1


r102 gnd   a0n_i 10e6
r101 gnd   a0p_i 10e6
r89  gnd   c0n   50
r90  gnd   c0p   50
r79  gnd   b0p   50
r80  gnd   b0n   50
ri2  n3    n4    50
ri1  n1    n2    50
v0   sel_i 0     DC=vcc
v8   vcc   0     DC=vcc
v5   gnd   0     DC=0
c55  c0n   c0n_i 75e-9
c56  c0p   c0p_i 75e-9
c45  b0p   b0p_i 75e-9
c46  b0n   b0n_i 75e-9
c40  a0n_i n4    75e-9
c41  a0p_i n2    75e-9


.END
