* BEGIN MODEL LMH6629
*//////////////////////////////////////////////////////////////////////
* (C) National Semiconductor, Corporation.
* Models developed and under copyright by:
* National Semiconductor, Corporation.  
*/////////////////////////////////////////////////////////////////////
* Legal Notice:  
* The model may be copied, and distributed without any modifications;
* however, reselling or licensing the material is illegal.
* We reserve the right to make changes to the model without prior notice. 
* Pspice Models are provided "AS IS, WITH NO WARRANTY OF ANY KIND" 
*////////////////////////////////////////////////////////////////////
*
* PINOUT ORDER +IN -IN +V -V OUT COMP
* PINOUT ORDER  4   3   8  5  7    6
.SUBCKT LMH6629 4 3 8 5 7 6
*
* SEE BELOW FOR MODEL PROGRAMMING, NOTES AND FEATURES
*
* BEGIN MODEL PROGRAMMING
* THE LINES BELOW ALLOW THE MODEL TO BE SET UP FOR
* DIFFERENT SUPPLY VOLTAGES.
*
* TO PROGRAM FOR SUPPLY VOLTAGE, COMMENT OUT THE GROUP
* OF STATEMENTS YOU DO NOT WANT TO USE. THE DEFAULT
* BELOW IS for 5 VOLT OPERATION.
*
*
* 5.0 VOLT GROUP
* OFFSET
V78 60 50 71E-6
* SLEW
R392 44 46 6E3
R422 44 35 675
* BANDWIDTH
C53 35 42 1.10E-12
C61 35 20 0.60E-12
* END 5.0 VOLT GROUP
* 3.3 VOLT GROUP
* OFFSET
*V78 60 50 97E-6
* SLEW
*R392 44 46 12E3
*R422 44 35 675
* BANDWIDTH
*C53 35 42 1.20E-12
*C61 35 20 0.63E-12
* END 3.3 VOLT GROUP
*
* END MODEL PROGRAMMING
*
* BEGIN MODEL NOTES
* COMP PIN:
* THE COMP MODE PIN HAS A THRESHOLD OF 1.4 VOLTS.
* FOR MODE ZERO (LO), PULL BELOW THRESHOLD OR LEAVE OPEN.
* FOR MODE ONE (HI), PULL ABOVE THRESHOLD
* BUT DO NOT EXCEED VCC. NOTE THAT WHEN COMP PIN
* IS LEFT FLOATING, IT MAY READ A VOLTAGE HIGHER THAN V+,
* BUT THE MODEL BEHAVES ACCORDING TO THE DEFAULT
* STATE WHICH IS COMP LO WHEN LEFT FLOATING.
* SOT23-5 EMULATION:
* SOT23-5 PACKAGE CAN BE EMULATED BY TYING THE COMP
* PIN HIGH.
* END MODEL NOTES
*
* MODEL FEATURES INCLUDE OPEN LOOP GAIN AND PHASE,
* OUTPUT SWING, OUTPUT CURRENT THRU THE SUPPLY RAILS,
* OUTPUT CURRENT LIMIT, CLOAD EFFECTS, RF EFFECTS,
* SLEW RATE, COMMON MODE REJECTION WITH FREQ EFFECTS,
* POWER SUPPLY REJECTION WITH FREQ EFFECTS, INPUT
* VOLTAGE NOISE WITH 1/F, INPUT CURRENT NOISE WITH
* 1/F, INPUT BIAS CURRENT, INPUT COMMON MODE RANGE,
* INPUT OFFSET VOLTAGE WITH TEMPERATURE EFFECTS,
* INPUT CAPACITANCE, COMP PIN FUNCTION INCLUDING
* THRESHOLD AND INPUT CURRENT, AND QUIESCENT CURRENT
* VS VOLTAGE AND TEMPERATURE. SHUTDOWN PIN
* AND ITS FUNCTIONALITY IS NOT INCLUDED IN THE MODEL.
*
Q36 5 9 10 QOP
Q37 8 11 10 QON
D37 7 8 DD
D38 5 7 DD
D39 12 0 DIN
D40 13 0 DIN
I24 0 12 0.1E-3
I25 0 13 0.1E-3
E99 14 0 5 0 1
E100 15 0 8 0 1
D41 16 0 DVN
D42 17 0 DVN
I26 0 16 3E-3
I27 0 17 3E-3
E101 18 3 16 17 3.65E-2
G23 4 18 12 13 8.73E-5
R381 5 8 1400
E102 19 0 15 20 1
E103 21 0 14 20 1
E104 22 0 23 0 1
R382 19 24 1E4
R383 21 25 1E4
R384 22 26 1E4
R385 0 24 0.1
R386 0 25 0.1
R387 0 26 0.1
E105 27 4 26 0 1.8
R388 28 23 10
R389 23 29 10
C48 19 24 3E-12
C49 21 25 3E-12
C50 22 26 115E-12
E106 30 27 25 0 0.05
E107 31 30 24 0 -0.1
Q38 14 32 11 QDP
Q39 15 32 9 QDN
I28 8 5 11.7E-3
I29 15 11 7.7E-4
I30 9 14 7.7E-4
R390 20 33 10
R391 20 32 10
C51 33 20 8E-12
C52 32 20 2.5E-12
E108 34 35 36 0 1
E109 35 37 36 0 1
E110 38 20 35 20 1
D43 39 15 DD
D44 14 40 DD
V73 37 40 1.35
V74 39 34 1.34
I31 0 41 1E-3
D45 41 0 DD
V75 36 41 -0.6551
D46 43 44 DD
D47 44 45 DD
R393 0 44 4.5E5
C54 18 0 0.85E-12
C55 31 0 0.85E-12
R394 10 47 0.25
G24 33 20 35 20 0.1
G25 32 20 33 20 0.1
L3 47 7 0.25E-9
R395 47 7 100
E111 43 38 36 0 2
E112 45 38 36 0 -2
C56 18 31 0.45E-12
G26 44 0 48 49 -6E-3
Q40 48 50 51 QIP
Q41 49 31 52 QIP
R397 51 53 0.1
R398 52 53 0.1
Q42 54 55 56 QIP
Q43 55 55 56 QIP
R399 57 48 50
R400 57 49 50
V76 54 53 0
V77 57 14 -0.3
C58 48 49 1E-13
D48 50 58 DIC
D49 31 58 DIC
E113 29 0 4 59 1
E114 28 0 18 59 1
C59 7 0 0.1P
R401 35 34 1E9
R402 37 35 1E9
R403 3 18 1E9
R404 4 27 1E9
R405 27 30 1E9
R406 30 31 1E9
R407 38 45 1E9
R408 38 43 1E9
G27 4 18 61 62 3.3E-4
R410 0 62 1E3
R411 0 62 1E3
R412 0 61 1E3
R413 0 61 1E3
E116 63 42 64 0 30
E117 65 0 64 0 -30
V79 66 65 15
V80 67 63 -15
R414 63 42 1E18
R415 65 0 1E18
M61 0 67 42 68 PSW L=1.5U W=150U
M62 42 66 0 69 NSW L=1.5U W=150U
R416 68 0 1E12
R417 69 0 1E12
E118 70 46 71 0 30
E119 72 35 71 0 -30
V81 73 72 15
V82 74 70 -15
R418 70 46 1E18
R419 72 35 1E18
M63 35 74 46 75 PSW L=1.5U W=150U
M64 46 73 35 76 NSW L=1.5U W=150U
R420 75 0 1E12
R421 76 0 1E12
E120 77 0 64 0 -1
V84 71 77 1
R423 0 77 1E12
R424 0 77 1E12
R425 0 71 1E12
E121 18 60 36 0 276E-6
V85 15 78 1.65
V86 15 56 -1
D50 79 31 DIC
D51 79 50 DIC
V87 80 14 0.275
E122 78 58 36 0 1.1
E123 79 80 36 0 1.1
E124 20 14 15 14 0.7
R427 0 20 1E12
V88 81 0 1
E125 82 81 36 0 -2
G28 55 14 82 0 5.25E-3
G29 8 5 36 0 -5E-3
Q44 83 84 85 QSW
R430 83 15 100E3
I32 15 86 10E-6
Q45 87 88 85 QSW
Q46 85 86 14 QSW
Q47 86 86 14 QSW
R431 87 15 100E3
E126 89 0 83 87 1
R432 0 89 200E3
R433 14 84 1E6
M65 64 89 0 0 NEN L=1.5U W=1500U
R434 64 90 50E3
V91 90 0 1
C63 83 87 35E-15
R435 6 84 1
C64 84 14 2E-12
C65 6 14 1E-12
C66 64 0 65E-15
I33 15 84 22E-6
V93 88 14 1.4
R436 0 81 1E9
R437 0 78 1E9
R438 0 36 1E9
R439 80 79 1E9
R440 0 82 1E9
R441 60 18 1E9
E127 59 14 15 14 0.7
R442 0 59 1E12
R443 0 59 1E12
.MODEL QDP PNP
.MODEL QDN NPN
.MODEL QON NPN VAF=150 BF=420 IKF=1.5 RE=0.5 RC=1
.MODEL QOP PNP VAF=150 BF=420 IKF=1.5 RE=0.5 RC=1
.MODEL QIP PNP VAF=150 BF=260 IKF=0.005 RB=1.4 RE=0.1 RC=1
.MODEL DVN D KF=4E-13
.MODEL DIN D KF=26E-14
.MODEL DIC D RS=0.1
.MODEL DD D
.MODEL PSW PMOS KP=200U VTO=-7.5 IS=1E-18
.MODEL NSW NMOS KP=200U VTO=7.5 IS=1E-18
.MODEL QSW NPN
.MODEL NEN NMOS KP=200U VTO=0.5 IS=1E-18
.ENDS
* END MODEL LMH6629
