//*****************************************************************************
//
// ektm4c129_qssi_boot_demo1.c - Simple example to blink the on-board LED.
//
// Copyright (c) 2013-2015 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.1.0.12573 of the EK-TM4C1294XL Firmware Package.
//
//*****************************************************************************
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_gpio.h"
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"

//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>ektm4c129_qssi_boot_demo1 (ektm4c129_qssi_boot_demo1)</h1>
//!
//! A very simple example that blinks the on-board LED D3. The USR_SW1
//! increases the blink rate and USR_SW2 decreases the blink rate
//
//*****************************************************************************

//*****************************************************************************
//
// Global variable for Delay Count
//
//*****************************************************************************
volatile uint32_t g_ui32Count;

//*****************************************************************************
//
// Interrupt Handler for detecting Port J User Switch Press
//
//*****************************************************************************
void
GPIOPortJInterrupt(void)
{
	uint32_t ui32IntStatus;

	//
	// Get the Interrupt Status
	//
	ui32IntStatus = GPIOIntStatus(GPIO_PORTJ_BASE, true);
	GPIOIntClear(GPIO_PORTJ_BASE, ui32IntStatus);

	//
	// If USR_SW1 is pressed increase blink rate
	//
	if((ui32IntStatus &  GPIO_INT_PIN_0) == GPIO_INT_PIN_0)
	{
		g_ui32Count = g_ui32Count + 40000;
	}

	//
	// If USR_SW2 is pressed decrease blink rate
	//
	if((ui32IntStatus &  GPIO_INT_PIN_1) == GPIO_INT_PIN_1)
	{
		if(g_ui32Count > 50000)
		{
			g_ui32Count = g_ui32Count - 40000;
		}
	}
}

//*****************************************************************************
//
// Blink the on-board LED.
//
//*****************************************************************************
int
main(void)
{
    volatile uint32_t ui32Loop;
    volatile uint32_t ui32LoopCount;

    //
    // Init Variables.
    //
    g_ui32Count   = 200000;
    ui32LoopCount = 200000;

    //
    // Enable the GPIO port that is used for the on-board LED.
    //
    SysCtlPeripheralDisable(SYSCTL_PERIPH_GPIOF);
    SysCtlPeripheralReset(SYSCTL_PERIPH_GPIOF);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    while(!(SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOF)));

    //
    // Configure the GPIO PF4 as Output
    //
    GPIOPinTypeGPIOOutput(GPIO_PORTF_AHB_BASE, GPIO_PIN_4);


    //
    // Drive the Pin Low
    //
    GPIOPinWrite(GPIO_PORTF_AHB_BASE, GPIO_PIN_4, 0x0);

    //
    // Enable the GPIO port that is used for the on-board Switch.
    //
    SysCtlPeripheralDisable(SYSCTL_PERIPH_GPIOJ);
    SysCtlPeripheralReset(SYSCTL_PERIPH_GPIOJ);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOJ);
    while(!(SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOJ)));

    //
    // Configure GPIO Port J pins 0 and 1 as inputs with Pull Up
    //
    GPIOPinTypeGPIOInput(GPIO_PORTJ_BASE, (GPIO_PIN_0 | GPIO_PIN_1));
    GPIOPadConfigSet(GPIO_PORTJ_BASE, (GPIO_PIN_0 | GPIO_PIN_1), GPIO_STRENGTH_2MA, GPIO_PIN_TYPE_STD_WPU);

    //
    // Configure Falling Edge Interrupt for Switch Press
    //
    GPIOIntClear(GPIO_PORTJ_BASE, (GPIO_INT_PIN_0 | GPIO_INT_PIN_1));
    GPIOIntTypeSet(GPIO_PORTJ_BASE, (GPIO_INT_PIN_0 | GPIO_INT_PIN_1),
    		GPIO_FALLING_EDGE);
    GPIOIntEnable(GPIO_PORTJ_BASE, (GPIO_INT_PIN_0 | GPIO_INT_PIN_1));
    IntEnable(INT_GPIOJ);

    //
    // Loop forever.
    //
    while(1)
    {
        //
        // Turn on the LED.
        //
        GPIOPinWrite(GPIO_PORTF_AHB_BASE, GPIO_PIN_4, GPIO_PIN_4);

        //
        // Delay for a bit.
        //
        for(ui32Loop = 0; ui32Loop < ui32LoopCount; ui32Loop++)
        {
        }

        //
        // Assign the new count value after previous count is over
        //
        ui32LoopCount = g_ui32Count;

        //
        // Turn off the LED.
        //
        GPIOPinWrite(GPIO_PORTF_AHB_BASE, GPIO_PIN_4, 0);

        //
        // Delay for a bit.
        //
        for(ui32Loop = 0; ui32Loop < ui32LoopCount; ui32Loop++)
        {
        }

        //
        // Assign the new count value after previous count is over
        //
        ui32LoopCount = g_ui32Count;
    }
}
